<?php
/*
 * Plugin Name: Volunpress
 * Plugin URI: https://www.volunpress.com
 * Description: Système gamifié de gestion des bénévoles avec points et récompenses pour associations à but non lucratif.
 * Version: 1.0.0
 * Author: Dukiwi SA
 * Author URI: https://www.dukiwi.com
 * License: GPL v2 or later
 * Text Domain: volunpress
 * Domain Path: /languages
 */

if (!defined('ABSPATH')) {
    exit;
}

define('VOLUNPRESS_VERSION', '1.0.0');
define('VOLUNPRESS_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('VOLUNPRESS_PLUGIN_URL', plugin_dir_url(__FILE__));
define('VOLUNPRESS_PLUGIN_BASENAME', plugin_basename(__FILE__));

// Inclure les fichiers nécessaires
require_once VOLUNPRESS_PLUGIN_DIR . 'includes/class-volunpress-db.php';
require_once VOLUNPRESS_PLUGIN_DIR . 'includes/class-volunpress-volunteer.php';
require_once VOLUNPRESS_PLUGIN_DIR . 'includes/class-volunpress-activity.php';
require_once VOLUNPRESS_PLUGIN_DIR . 'includes/class-volunpress-reward.php';
require_once VOLUNPRESS_PLUGIN_DIR . 'includes/class-volunpress-shortcodes.php';

if (is_admin()) {
    require_once VOLUNPRESS_PLUGIN_DIR . 'admin/class-volunpress-admin.php';
}

class Volunpress {
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        add_action('init', array($this, 'init'));
        add_action('wp_enqueue_scripts', array($this, 'enqueue_public_assets'));
        register_activation_hook(__FILE__, array('Volunpress_DB', 'create_tables'));
        register_deactivation_hook(__FILE__, array($this, 'deactivate'));
    }
    
    public function init() {
        load_plugin_textdomain('volunpress', false, dirname(VOLUNPRESS_PLUGIN_BASENAME) . '/languages');
        Volunpress_Shortcodes::init();
    }
    
    public function enqueue_public_assets() {
        wp_enqueue_style('volunpress-public', VOLUNPRESS_PLUGIN_URL . 'assets/css/public.css', array(), VOLUNPRESS_VERSION);
        wp_enqueue_script('volunpress-public', VOLUNPRESS_PLUGIN_URL . 'assets/js/public.js', array('jquery'), VOLUNPRESS_VERSION, true);
    }
    
    public function deactivate() {
        flush_rewrite_rules();
    }
    
    public static function get_option($key, $default = '') {
        $options = get_option('volunpress_options', array());
        return isset($options[$key]) ? $options[$key] : $default;
    }
    
    public static function update_option($key, $value) {
        $options = get_option('volunpress_options', array());
        $options[$key] = $value;
        update_option('volunpress_options', $options);
    }
}

Volunpress::get_instance();
