<?php
if (!defined('ABSPATH')) {
    exit;
}

class Volunpress_DB {
    
    public static function create_tables() {
        global $wpdb;
        $charset_collate = $wpdb->get_charset_collate();
        
        // Table des bénévoles
        $table_volunteers = $wpdb->prefix . 'volunpress_volunteers';
        $sql_volunteers = "CREATE TABLE $table_volunteers (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            first_name varchar(100) NOT NULL,
            last_name varchar(100) NOT NULL,
            email varchar(100) NOT NULL,
            phone varchar(30) DEFAULT '',
            is_committee_member tinyint(1) DEFAULT 0,
            is_active tinyint(1) DEFAULT 1,
            total_points int(11) DEFAULT 0,
            membership_paid tinyint(1) DEFAULT 0,
            membership_year year DEFAULT NULL,
            avatar_url varchar(255) DEFAULT '',
            level int(11) DEFAULT 1,
            joined_date date NOT NULL,
            left_date date DEFAULT NULL,
            notes text DEFAULT '',
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            KEY email (email),
            KEY is_active (is_active)
        ) $charset_collate;";
        
        // Table des activités/heures
        $table_activities = $wpdb->prefix . 'volunpress_activities';
        $sql_activities = "CREATE TABLE $table_activities (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            volunteer_id bigint(20) NOT NULL,
            activity_type varchar(50) NOT NULL,
            description varchar(255) NOT NULL,
            hours decimal(5,2) DEFAULT 0,
            points int(11) NOT NULL,
            activity_date date NOT NULL,
            added_by bigint(20) NOT NULL,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            KEY volunteer_id (volunteer_id),
            KEY activity_type (activity_type),
            KEY activity_date (activity_date)
        ) $charset_collate;";
        
        // Table des récompenses
        $table_rewards = $wpdb->prefix . 'volunpress_rewards';
        $sql_rewards = "CREATE TABLE $table_rewards (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            name varchar(150) NOT NULL,
            description text DEFAULT '',
            points_required int(11) NOT NULL,
            quantity_available int(11) DEFAULT -1,
            image_url varchar(255) DEFAULT '',
            is_active tinyint(1) DEFAULT 1,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            KEY points_required (points_required)
        ) $charset_collate;";
        
        // Table des réclamations de récompenses
        $table_claims = $wpdb->prefix . 'volunpress_claims';
        $sql_claims = "CREATE TABLE $table_claims (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            volunteer_id bigint(20) NOT NULL,
            reward_id bigint(20) NOT NULL,
            points_spent int(11) NOT NULL,
            status varchar(20) DEFAULT 'pending',
            claimed_at datetime DEFAULT CURRENT_TIMESTAMP,
            processed_at datetime DEFAULT NULL,
            processed_by bigint(20) DEFAULT NULL,
            PRIMARY KEY (id),
            KEY volunteer_id (volunteer_id),
            KEY status (status)
        ) $charset_collate;";
        
        // Table des niveaux
        $table_levels = $wpdb->prefix . 'volunpress_levels';
        $sql_levels = "CREATE TABLE $table_levels (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            level_number int(11) NOT NULL,
            name varchar(100) NOT NULL,
            min_points int(11) NOT NULL,
            badge_icon varchar(100) DEFAULT '',
            color varchar(7) DEFAULT '#3498db',
            PRIMARY KEY (id),
            UNIQUE KEY level_number (level_number)
        ) $charset_collate;";
        
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql_volunteers);
        dbDelta($sql_activities);
        dbDelta($sql_rewards);
        dbDelta($sql_claims);
        dbDelta($sql_levels);
        
        // Insérer les niveaux par défaut
        self::insert_default_levels();
        
        // Options par défaut
        self::insert_default_options();
        
        update_option('volunpress_db_version', VOLUNPRESS_VERSION);
    }
    
    private static function insert_default_levels() {
        global $wpdb;
        $table = $wpdb->prefix . 'volunpress_levels';
        
        $count = $wpdb->get_var("SELECT COUNT(*) FROM $table");
        if ($count > 0) return;
        
        $levels = array(
            array(1, 'Débutant', 0, 'seedling', '#95a5a6'),
            array(2, 'Apprenti', 50, 'leaf', '#27ae60'),
            array(3, 'Confirmé', 150, 'tree', '#2ecc71'),
            array(4, 'Expert', 300, 'star', '#f39c12'),
            array(5, 'Maître', 500, 'crown', '#e74c3c'),
            array(6, 'Légende', 1000, 'trophy', '#9b59b6'),
        );
        
        foreach ($levels as $level) {
            $wpdb->insert($table, array(
                'level_number' => $level[0],
                'name' => $level[1],
                'min_points' => $level[2],
                'badge_icon' => $level[3],
                'color' => $level[4],
            ));
        }
    }
    
    private static function insert_default_options() {
        $defaults = array(
            'points_per_hour' => 10,
            'points_membership' => 20,
            'display_name_format' => 'initial',
            'currency_name' => 'points',
            'organization_name' => '',
            'primary_color' => '#3498db',
            'secondary_color' => '#2ecc71',
            'show_leaderboard' => 1,
            'leaderboard_limit' => 10,
            'donation_points_ratio' => 1,
        );
        
        $existing = get_option('volunpress_options', array());
        $options = array_merge($defaults, $existing);
        update_option('volunpress_options', $options);
    }
    
    public static function get_table($name) {
        global $wpdb;
        return $wpdb->prefix . 'volunpress_' . $name;
    }
}
