/**
 * Volunpress Public JavaScript
 */
(function($) {
    'use strict';

    $(document).ready(function() {
        // Animate progress bars on scroll
        function animateProgressBars() {
            $('.vp-progress-fill, .vp-progress-bar').each(function() {
                var $this = $(this);
                var width = $this.css('width');
                
                if (!$this.hasClass('animated')) {
                    $this.css('width', '0');
                    setTimeout(function() {
                        $this.css('width', width);
                        $this.addClass('animated');
                    }, 100);
                }
            });
        }

        // Check if element is in viewport
        function isInViewport(element) {
            var rect = element.getBoundingClientRect();
            return (
                rect.top >= 0 &&
                rect.left >= 0 &&
                rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) &&
                rect.right <= (window.innerWidth || document.documentElement.clientWidth)
            );
        }

        // Trigger animation when scrolling
        $(window).on('scroll load', function() {
            $('.volunpress-card, .volunpress-leaderboard').each(function() {
                if (isInViewport(this)) {
                    animateProgressBars();
                }
            });
        });

        // Initial check
        animateProgressBars();

        // Counter animation for stats
        $('.vp-stat-value, .vp-points-value').each(function() {
            var $this = $(this);
            var target = parseInt($this.text().replace(/[^0-9]/g, ''));
            
            if (target && !$this.hasClass('counted')) {
                $this.addClass('counted');
                var suffix = $this.text().replace(/[0-9,.\s]/g, '');
                
                $({ count: 0 }).animate({ count: target }, {
                    duration: 1500,
                    easing: 'swing',
                    step: function() {
                        $this.text(Math.floor(this.count).toLocaleString() + suffix);
                    },
                    complete: function() {
                        $this.text(target.toLocaleString() + suffix);
                    }
                });
            }
        });
    });

})(jQuery);
