/**
 * Volunpress Admin JavaScript
 */
(function($) {
    'use strict';

    $(document).ready(function() {
        // Quick add points
        $('.vp-quick-points-btn').on('click', function(e) {
            e.preventDefault();
            var volunteerId = $(this).data('volunteer-id');
            var points = prompt('Nombre de points à ajouter:');
            var description = prompt('Description:');
            
            if (points && description) {
                $.post(volunpress.ajax_url, {
                    action: 'volunpress_quick_add_points',
                    nonce: volunpress.nonce,
                    volunteer_id: volunteerId,
                    points: points,
                    description: description
                }, function(response) {
                    if (response.success) {
                        location.reload();
                    } else {
                        alert('Erreur: ' + response.data);
                    }
                });
            }
        });

        // Confirm delete actions
        $('.vp-confirm-delete').on('click', function(e) {
            if (!confirm('Êtes-vous sûr de vouloir supprimer cet élément ?')) {
                e.preventDefault();
            }
        });

        // Activity type toggle
        $('#activity_type').on('change', function() {
            var type = $(this).val();
            if (type === 'hours') {
                $('#hours-field').show();
                $('#points-field').hide();
                $('#hours').prop('required', true);
                $('#points').prop('required', false);
            } else {
                $('#hours-field').hide();
                $('#points-field').show();
                $('#hours').prop('required', false);
                $('#points').prop('required', true);
                
                // Show donation hint
                if (type === 'donation') {
                    $('#donation-hint').show();
                } else {
                    $('#donation-hint').hide();
                }
            }
        });

        // Initialize on page load
        if ($('#activity_type').length) {
            $('#activity_type').trigger('change');
        }

        // Dismiss notices
        $('.notice.is-dismissible').on('click', '.notice-dismiss', function() {
            $(this).closest('.notice').fadeOut();
        });
    });

})(jQuery);
