<?php
if (!defined('ABSPATH')) {
    exit;
}

$action = isset($_GET['action']) ? sanitize_text_field($_GET['action']) : 'list';
$edit_id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
$message = isset($_GET['message']) ? sanitize_text_field($_GET['message']) : '';
$currency = Volunpress::get_option('currency_name', 'points');

if ($action === 'edit' && $edit_id) {
    $volunteer = Volunpress_Volunteer::get($edit_id);
}
?>

<div class="wrap volunpress-wrap">
    <h1 class="wp-heading-inline">
        <?php 
        if ($action === 'new') {
            esc_html_e('Nouveau bénévole', 'volunpress');
        } elseif ($action === 'edit') {
            esc_html_e('Modifier le bénévole', 'volunpress');
        } else {
            esc_html_e('Bénévoles', 'volunpress');
        }
        ?>
    </h1>
    
    <?php if ($action === 'list'): ?>
    <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-volunteers&action=new')); ?>" class="page-title-action"><?php esc_html_e('Ajouter', 'volunpress'); ?></a>
    <?php else: ?>
    <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-volunteers')); ?>" class="page-title-action"><?php esc_html_e('← Retour à la liste', 'volunpress'); ?></a>
    <?php endif; ?>
    
    <?php if ($message): ?>
    <div class="notice notice-success is-dismissible"><p><?php echo esc_html($message); ?></p></div>
    <?php endif; ?>
    
    <?php if ($action === 'new' || $action === 'edit'): ?>
    <!-- Formulaire -->
    <form method="post" class="vp-form">
        <?php wp_nonce_field('volunpress_volunteer'); ?>
        <?php if ($action === 'edit'): ?>
        <input type="hidden" name="volunteer_id" value="<?php echo esc_attr($edit_id); ?>">
        <?php endif; ?>
        
        <div class="vp-form-grid">
            <div class="vp-form-main">
                <div class="vp-box">
                    <h2 class="vp-box-title"><?php esc_html_e('Informations', 'volunpress'); ?></h2>
                    
                    <div class="vp-form-row">
                        <div class="vp-form-col">
                            <label for="first_name"><?php esc_html_e('Prénom', 'volunpress'); ?> *</label>
                            <input type="text" name="first_name" id="first_name" required value="<?php echo isset($volunteer) ? esc_attr($volunteer->first_name) : ''; ?>">
                        </div>
                        <div class="vp-form-col">
                            <label for="last_name"><?php esc_html_e('Nom', 'volunpress'); ?> *</label>
                            <input type="text" name="last_name" id="last_name" required value="<?php echo isset($volunteer) ? esc_attr($volunteer->last_name) : ''; ?>">
                        </div>
                    </div>
                    
                    <div class="vp-form-row">
                        <div class="vp-form-col">
                            <label for="email"><?php esc_html_e('Email', 'volunpress'); ?> *</label>
                            <input type="email" name="email" id="email" required value="<?php echo isset($volunteer) ? esc_attr($volunteer->email) : ''; ?>">
                        </div>
                        <div class="vp-form-col">
                            <label for="phone"><?php esc_html_e('Téléphone', 'volunpress'); ?></label>
                            <input type="text" name="phone" id="phone" value="<?php echo isset($volunteer) ? esc_attr($volunteer->phone) : ''; ?>">
                        </div>
                    </div>
                    
                    <div class="vp-form-row">
                        <div class="vp-form-col">
                            <label for="joined_date"><?php esc_html_e('Date d\'arrivée', 'volunpress'); ?> *</label>
                            <input type="date" name="joined_date" id="joined_date" required value="<?php echo isset($volunteer) ? esc_attr($volunteer->joined_date) : esc_attr(date('Y-m-d')); ?>">
                        </div>
                        <div class="vp-form-col">
                            <label for="left_date"><?php esc_html_e('Date de départ', 'volunpress'); ?></label>
                            <input type="date" name="left_date" id="left_date" value="<?php echo isset($volunteer) && $volunteer->left_date ? esc_attr($volunteer->left_date) : ''; ?>">
                            <small><?php esc_html_e('Laisser vide si toujours actif', 'volunpress'); ?></small>
                        </div>
                    </div>
                    
                    <div class="vp-form-row">
                        <label for="notes"><?php esc_html_e('Notes', 'volunpress'); ?></label>
                        <textarea name="notes" id="notes" rows="3"><?php echo isset($volunteer) ? esc_textarea($volunteer->notes) : ''; ?></textarea>
                    </div>
                </div>
            </div>
            
            <div class="vp-form-side">
                <div class="vp-box">
                    <h2 class="vp-box-title"><?php esc_html_e('Statut', 'volunpress'); ?></h2>
                    
                    <div class="vp-checkbox-group">
                        <label>
                            <input type="checkbox" name="is_active" value="1" <?php checked(isset($volunteer) ? $volunteer->is_active : 1, 1); ?>>
                            <?php esc_html_e('Bénévole actif', 'volunpress'); ?>
                        </label>
                        
                        <label>
                            <input type="checkbox" name="is_committee_member" value="1" <?php checked(isset($volunteer) ? $volunteer->is_committee_member : 0, 1); ?>>
                            <?php esc_html_e('Membre du comité', 'volunpress'); ?>
                        </label>
                    </div>
                </div>
                
                <div class="vp-box">
                    <h2 class="vp-box-title"><?php esc_html_e('Cotisation', 'volunpress'); ?></h2>
                    
                    <label>
                        <input type="checkbox" name="membership_paid" value="1" <?php checked(isset($volunteer) ? $volunteer->membership_paid : 0, 1); ?>>
                        <?php esc_html_e('Cotisation payée', 'volunpress'); ?>
                    </label>
                    
                    <div class="vp-form-row" style="margin-top: 10px;">
                        <label for="membership_year"><?php esc_html_e('Année', 'volunpress'); ?></label>
                        <input type="number" name="membership_year" id="membership_year" min="2000" max="2100" value="<?php echo isset($volunteer) && $volunteer->membership_year ? esc_attr($volunteer->membership_year) : esc_attr(date('Y')); ?>">
                    </div>
                    
                    <p class="description">
                        <?php printf(esc_html__('La cotisation donne %d %s', 'volunpress'), Volunpress::get_option('points_membership', 20), $currency); ?>
                    </p>
                </div>
                
                <?php if ($action === 'edit' && isset($volunteer)): ?>
                <div class="vp-box">
                    <h2 class="vp-box-title"><?php esc_html_e('Points', 'volunpress'); ?></h2>
                    <div class="vp-points-display">
                        <span class="vp-big-number"><?php echo esc_html(number_format($volunteer->total_points)); ?></span>
                        <span class="vp-points-label"><?php echo esc_html($currency); ?></span>
                    </div>
                    <?php 
                    $level_info = Volunpress_Volunteer::get_level_info($volunteer->id);
                    if ($level_info): 
                    ?>
                    <div class="vp-level-info">
                        <span class="vp-level-badge" style="background: <?php echo esc_attr($level_info['current']->color); ?>">
                            <?php echo esc_html($level_info['current']->name); ?>
                        </span>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                
                <button type="submit" name="volunpress_save_volunteer" class="button button-primary button-large vp-btn-full">
                    <?php echo $action === 'edit' ? esc_html__('Mettre à jour', 'volunpress') : esc_html__('Créer le bénévole', 'volunpress'); ?>
                </button>
            </div>
        </div>
    </form>
    
    <?php else: ?>
    <!-- Liste des bénévoles -->
    <?php 
    $filter_active = isset($_GET['filter_active']) ? $_GET['filter_active'] : '';
    $filter_committee = isset($_GET['filter_committee']) ? $_GET['filter_committee'] : '';
    
    $args = array();
    if ($filter_active !== '') $args['is_active'] = (int) $filter_active;
    if ($filter_committee !== '') $args['is_committee_member'] = (int) $filter_committee;
    
    $volunteers = Volunpress_Volunteer::get_all($args);
    ?>
    
    <div class="vp-filters">
        <form method="get">
            <input type="hidden" name="page" value="volunpress-volunteers">
            <select name="filter_active">
                <option value=""><?php esc_html_e('Tous les statuts', 'volunpress'); ?></option>
                <option value="1" <?php selected($filter_active, '1'); ?>><?php esc_html_e('Actifs', 'volunpress'); ?></option>
                <option value="0" <?php selected($filter_active, '0'); ?>><?php esc_html_e('Inactifs', 'volunpress'); ?></option>
            </select>
            <select name="filter_committee">
                <option value=""><?php esc_html_e('Tous les rôles', 'volunpress'); ?></option>
                <option value="1" <?php selected($filter_committee, '1'); ?>><?php esc_html_e('Comité', 'volunpress'); ?></option>
                <option value="0" <?php selected($filter_committee, '0'); ?>><?php esc_html_e('Bénévoles', 'volunpress'); ?></option>
            </select>
            <button type="submit" class="button"><?php esc_html_e('Filtrer', 'volunpress'); ?></button>
        </form>
    </div>
    
    <table class="wp-list-table widefat fixed striped vp-table">
        <thead>
            <tr>
                <th><?php esc_html_e('Nom', 'volunpress'); ?></th>
                <th><?php esc_html_e('Email', 'volunpress'); ?></th>
                <th><?php esc_html_e('Niveau', 'volunpress'); ?></th>
                <th class="vp-col-center"><?php echo esc_html(ucfirst($currency)); ?></th>
                <th class="vp-col-center"><?php esc_html_e('Comité', 'volunpress'); ?></th>
                <th class="vp-col-center"><?php esc_html_e('Cotisation', 'volunpress'); ?></th>
                <th class="vp-col-center"><?php esc_html_e('Statut', 'volunpress'); ?></th>
                <th><?php esc_html_e('Actions', 'volunpress'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if ($volunteers): foreach ($volunteers as $vol): 
                $level_info = Volunpress_Volunteer::get_level_info($vol->id);
            ?>
            <tr>
                <td>
                    <strong><?php echo esc_html($vol->first_name . ' ' . $vol->last_name); ?></strong>
                </td>
                <td><?php echo esc_html($vol->email); ?></td>
                <td>
                    <?php if ($level_info): ?>
                    <span class="vp-level-badge" style="background: <?php echo esc_attr($level_info['current']->color); ?>">
                        <?php echo esc_html($level_info['current']->name); ?>
                    </span>
                    <?php endif; ?>
                </td>
                <td class="vp-col-center">
                    <strong><?php echo esc_html(number_format($vol->total_points)); ?></strong>
                </td>
                <td class="vp-col-center">
                    <?php echo $vol->is_committee_member ? '<span class="vp-badge vp-badge-gold">⭐ Oui</span>' : '<span class="vp-badge">Non</span>'; ?>
                </td>
                <td class="vp-col-center">
                    <?php echo $vol->membership_paid ? '<span class="vp-badge vp-badge-green">✓</span>' : '<span class="vp-badge vp-badge-red">✗</span>'; ?>
                </td>
                <td class="vp-col-center">
                    <?php echo $vol->is_active ? '<span class="vp-badge vp-badge-green">Actif</span>' : '<span class="vp-badge vp-badge-gray">Inactif</span>'; ?>
                </td>
                <td>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-volunteers&action=edit&id=' . $vol->id)); ?>" class="button button-small"><?php esc_html_e('Modifier', 'volunpress'); ?></a>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-activities&action=new&volunteer_id=' . $vol->id)); ?>" class="button button-small"><?php esc_html_e('+ Points', 'volunpress'); ?></a>
                    <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=volunpress-volunteers&action=delete_volunteer&id=' . $vol->id), 'delete_volunteer_' . $vol->id)); ?>" class="button button-small vp-btn-danger" onclick="return confirm('<?php esc_attr_e('Supprimer ce bénévole ?', 'volunpress'); ?>');"><?php esc_html_e('Supprimer', 'volunpress'); ?></a>
                </td>
            </tr>
            <?php endforeach; else: ?>
            <tr><td colspan="8" class="vp-empty-row"><?php esc_html_e('Aucun bénévole trouvé.', 'volunpress'); ?></td></tr>
            <?php endif; ?>
        </tbody>
    </table>
    <?php endif; ?>
</div>
