<?php
if (!defined('ABSPATH')) {
    exit;
}

$action = isset($_GET['action']) ? sanitize_text_field($_GET['action']) : 'list';
$edit_id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
$message = isset($_GET['message']) ? sanitize_text_field($_GET['message']) : '';
$currency = Volunpress::get_option('currency_name', 'points');

if ($action === 'edit' && $edit_id) {
    $reward = Volunpress_Reward::get($edit_id);
}
?>

<div class="wrap volunpress-wrap">
    <h1 class="wp-heading-inline">
        <?php 
        if ($action === 'new') {
            esc_html_e('Nouvelle récompense', 'volunpress');
        } elseif ($action === 'edit') {
            esc_html_e('Modifier la récompense', 'volunpress');
        } else {
            esc_html_e('Récompenses', 'volunpress');
        }
        ?>
    </h1>
    
    <?php if ($action === 'list'): ?>
    <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-rewards&action=new')); ?>" class="page-title-action"><?php esc_html_e('Ajouter', 'volunpress'); ?></a>
    <?php else: ?>
    <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-rewards')); ?>" class="page-title-action"><?php esc_html_e('← Retour à la liste', 'volunpress'); ?></a>
    <?php endif; ?>
    
    <?php if ($message): ?>
    <div class="notice notice-success is-dismissible"><p><?php echo esc_html($message); ?></p></div>
    <?php endif; ?>
    
    <?php if ($action === 'new' || $action === 'edit'): ?>
    <!-- Formulaire -->
    <form method="post" class="vp-form">
        <?php wp_nonce_field('volunpress_reward'); ?>
        <?php if ($action === 'edit'): ?>
        <input type="hidden" name="reward_id" value="<?php echo esc_attr($edit_id); ?>">
        <?php endif; ?>
        
        <div class="vp-form-grid">
            <div class="vp-form-main">
                <div class="vp-box">
                    <h2 class="vp-box-title"><?php esc_html_e('Informations', 'volunpress'); ?></h2>
                    
                    <div class="vp-form-row">
                        <label for="name"><?php esc_html_e('Nom de la récompense', 'volunpress'); ?> *</label>
                        <input type="text" name="name" id="name" required value="<?php echo isset($reward) ? esc_attr($reward->name) : ''; ?>" placeholder="<?php esc_attr_e('Ex: T-Shirt du club', 'volunpress'); ?>">
                    </div>
                    
                    <div class="vp-form-row">
                        <label for="description"><?php esc_html_e('Description', 'volunpress'); ?></label>
                        <textarea name="description" id="description" rows="3" placeholder="<?php esc_attr_e('Description de la récompense...', 'volunpress'); ?>"><?php echo isset($reward) ? esc_textarea($reward->description) : ''; ?></textarea>
                    </div>
                    
                    <div class="vp-form-row vp-form-row-flex">
                        <div class="vp-form-col">
                            <label for="points_required"><?php echo esc_html(ucfirst($currency)); ?> <?php esc_html_e('requis', 'volunpress'); ?> *</label>
                            <input type="number" name="points_required" id="points_required" required min="0" value="<?php echo isset($reward) ? esc_attr($reward->points_required) : '100'; ?>">
                        </div>
                        <div class="vp-form-col">
                            <label for="quantity_available"><?php esc_html_e('Quantité disponible', 'volunpress'); ?></label>
                            <input type="number" name="quantity_available" id="quantity_available" min="-1" value="<?php echo isset($reward) ? esc_attr($reward->quantity_available) : '-1'; ?>">
                            <small><?php esc_html_e('-1 = illimité', 'volunpress'); ?></small>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="vp-form-side">
                <div class="vp-box">
                    <h2 class="vp-box-title"><?php esc_html_e('Image', 'volunpress'); ?></h2>
                    
                    <div class="vp-image-upload">
                        <div class="vp-image-preview" id="image-preview">
                            <?php if (isset($reward) && $reward->image_url): ?>
                            <img src="<?php echo esc_url($reward->image_url); ?>" alt="">
                            <?php else: ?>
                            <span class="vp-no-image">🎁</span>
                            <?php endif; ?>
                        </div>
                        <input type="hidden" name="image_url" id="image_url" value="<?php echo isset($reward) ? esc_attr($reward->image_url) : ''; ?>">
                        <button type="button" class="button" id="upload-image-btn"><?php esc_html_e('Choisir une image', 'volunpress'); ?></button>
                        <button type="button" class="button" id="remove-image-btn" style="<?php echo (isset($reward) && $reward->image_url) ? '' : 'display:none'; ?>"><?php esc_html_e('Supprimer', 'volunpress'); ?></button>
                    </div>
                </div>
                
                <div class="vp-box">
                    <h2 class="vp-box-title"><?php esc_html_e('Statut', 'volunpress'); ?></h2>
                    <label>
                        <input type="checkbox" name="is_active" value="1" <?php checked(isset($reward) ? $reward->is_active : 1, 1); ?>>
                        <?php esc_html_e('Récompense active', 'volunpress'); ?>
                    </label>
                </div>
                
                <button type="submit" name="volunpress_save_reward" class="button button-primary button-large vp-btn-full">
                    <?php echo $action === 'edit' ? esc_html__('Mettre à jour', 'volunpress') : esc_html__('Créer la récompense', 'volunpress'); ?>
                </button>
            </div>
        </div>
    </form>
    
    <script>
    jQuery(function($) {
        var frame;
        $('#upload-image-btn').on('click', function(e) {
            e.preventDefault();
            if (frame) { frame.open(); return; }
            frame = wp.media({
                title: '<?php esc_attr_e('Choisir une image', 'volunpress'); ?>',
                button: { text: '<?php esc_attr_e('Utiliser cette image', 'volunpress'); ?>' },
                multiple: false
            });
            frame.on('select', function() {
                var attachment = frame.state().get('selection').first().toJSON();
                $('#image_url').val(attachment.url);
                $('#image-preview').html('<img src="' + attachment.url + '" alt="">');
                $('#remove-image-btn').show();
            });
            frame.open();
        });
        
        $('#remove-image-btn').on('click', function() {
            $('#image_url').val('');
            $('#image-preview').html('<span class="vp-no-image">🎁</span>');
            $(this).hide();
        });
    });
    </script>
    
    <?php else: ?>
    <!-- Liste des récompenses -->
    <?php $rewards = Volunpress_Reward::get_all(); ?>
    
    <div class="vp-rewards-grid">
        <?php if ($rewards): foreach ($rewards as $rew): ?>
        <div class="vp-reward-admin-card <?php echo !$rew->is_active ? 'vp-inactive' : ''; ?>">
            <div class="vp-reward-image">
                <?php if ($rew->image_url): ?>
                <img src="<?php echo esc_url($rew->image_url); ?>" alt="<?php echo esc_attr($rew->name); ?>">
                <?php else: ?>
                <span class="vp-no-image">🎁</span>
                <?php endif; ?>
            </div>
            <div class="vp-reward-content">
                <h3><?php echo esc_html($rew->name); ?></h3>
                <?php if ($rew->description): ?>
                <p><?php echo esc_html(wp_trim_words($rew->description, 15)); ?></p>
                <?php endif; ?>
                <div class="vp-reward-meta">
                    <span class="vp-reward-points"><?php echo esc_html(number_format($rew->points_required)); ?> <?php echo esc_html($currency); ?></span>
                    <span class="vp-reward-stock">
                        <?php 
                        if ($rew->quantity_available === -1) {
                            echo '∞';
                        } elseif ($rew->quantity_available === 0) {
                            echo '<span class="vp-out">' . esc_html__('Épuisé', 'volunpress') . '</span>';
                        } else {
                            printf(esc_html__('%d dispo', 'volunpress'), $rew->quantity_available);
                        }
                        ?>
                    </span>
                </div>
                <?php if (!$rew->is_active): ?>
                <span class="vp-inactive-badge"><?php esc_html_e('Inactif', 'volunpress'); ?></span>
                <?php endif; ?>
            </div>
            <div class="vp-reward-actions">
                <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-rewards&action=edit&id=' . $rew->id)); ?>" class="button"><?php esc_html_e('Modifier', 'volunpress'); ?></a>
                <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=volunpress-rewards&action=delete_reward&id=' . $rew->id), 'delete_reward_' . $rew->id)); ?>" class="button vp-btn-danger" onclick="return confirm('<?php esc_attr_e('Supprimer cette récompense ?', 'volunpress'); ?>');"><?php esc_html_e('Supprimer', 'volunpress'); ?></a>
            </div>
        </div>
        <?php endforeach; else: ?>
        <div class="vp-empty-state">
            <span class="vp-empty-icon">🎁</span>
            <p><?php esc_html_e('Aucune récompense créée.', 'volunpress'); ?></p>
            <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-rewards&action=new')); ?>" class="button button-primary"><?php esc_html_e('Créer la première récompense', 'volunpress'); ?></a>
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>
</div>
