<?php
if (!defined('ABSPATH')) {
    exit;
}

$message = isset($_GET['message']) ? sanitize_text_field($_GET['message']) : '';
$options = get_option('volunpress_options', array());
?>

<div class="wrap volunpress-wrap">
    <h1><?php esc_html_e('Options Volunpress', 'volunpress'); ?></h1>
    
    <?php if ($message): ?>
    <div class="notice notice-success is-dismissible"><p><?php echo esc_html($message); ?></p></div>
    <?php endif; ?>
    
    <form method="post" class="vp-form">
        <?php wp_nonce_field('volunpress_options'); ?>
        
        <div class="vp-options-grid">
            <!-- Paramètres généraux -->
            <div class="vp-box">
                <h2 class="vp-box-title"><span>⚙️</span> <?php esc_html_e('Paramètres généraux', 'volunpress'); ?></h2>
                
                <div class="vp-form-row">
                    <label for="organization_name"><?php esc_html_e('Nom de l\'organisation', 'volunpress'); ?></label>
                    <input type="text" name="organization_name" id="organization_name" value="<?php echo esc_attr($options['organization_name'] ?? ''); ?>" placeholder="<?php esc_attr_e('Mon Association', 'volunpress'); ?>">
                </div>
                
                <div class="vp-form-row">
                    <label for="currency_name"><?php esc_html_e('Nom de la monnaie/points', 'volunpress'); ?></label>
                    <input type="text" name="currency_name" id="currency_name" value="<?php echo esc_attr($options['currency_name'] ?? 'points'); ?>" placeholder="points">
                    <small><?php esc_html_e('Ex: points, étoiles, crédits, pièces...', 'volunpress'); ?></small>
                </div>
            </div>
            
            <!-- Système de points -->
            <div class="vp-box">
                <h2 class="vp-box-title"><span>⭐</span> <?php esc_html_e('Système de points', 'volunpress'); ?></h2>
                
                <div class="vp-form-row">
                    <label for="points_per_hour"><?php esc_html_e('Points par heure de bénévolat', 'volunpress'); ?></label>
                    <input type="number" name="points_per_hour" id="points_per_hour" min="1" value="<?php echo esc_attr($options['points_per_hour'] ?? 10); ?>">
                </div>
                
                <div class="vp-form-row">
                    <label for="points_membership"><?php esc_html_e('Points pour cotisation payée', 'volunpress'); ?></label>
                    <input type="number" name="points_membership" id="points_membership" min="0" value="<?php echo esc_attr($options['points_membership'] ?? 20); ?>">
                </div>
                
                <div class="vp-form-row">
                    <label for="donation_points_ratio"><?php esc_html_e('Ratio don → points (ex: 1 CHF = X points)', 'volunpress'); ?></label>
                    <input type="number" name="donation_points_ratio" id="donation_points_ratio" min="0.1" step="0.1" value="<?php echo esc_attr($options['donation_points_ratio'] ?? 1); ?>">
                    <small><?php esc_html_e('Pour convertir les dons en points', 'volunpress'); ?></small>
                </div>
            </div>
            
            <!-- Affichage -->
            <div class="vp-box">
                <h2 class="vp-box-title"><span>👁️</span> <?php esc_html_e('Affichage', 'volunpress'); ?></h2>
                
                <div class="vp-form-row">
                    <label for="display_name_format"><?php esc_html_e('Format du nom affiché', 'volunpress'); ?></label>
                    <select name="display_name_format" id="display_name_format">
                        <option value="initial" <?php selected($options['display_name_format'] ?? 'initial', 'initial'); ?>><?php esc_html_e('Prénom + Initiale (Karl B.)', 'volunpress'); ?></option>
                        <option value="full" <?php selected($options['display_name_format'] ?? 'initial', 'full'); ?>><?php esc_html_e('Nom complet (Karl Bauer)', 'volunpress'); ?></option>
                    </select>
                    <small><?php esc_html_e('Format utilisé sur le site public', 'volunpress'); ?></small>
                </div>
                
                <div class="vp-form-row">
                    <label>
                        <input type="checkbox" name="show_leaderboard" value="1" <?php checked($options['show_leaderboard'] ?? 1, 1); ?>>
                        <?php esc_html_e('Activer le classement public', 'volunpress'); ?>
                    </label>
                </div>
                
                <div class="vp-form-row">
                    <label for="leaderboard_limit"><?php esc_html_e('Nombre de bénévoles dans le classement', 'volunpress'); ?></label>
                    <input type="number" name="leaderboard_limit" id="leaderboard_limit" min="3" max="100" value="<?php echo esc_attr($options['leaderboard_limit'] ?? 10); ?>">
                </div>
            </div>
            
            <!-- Couleurs -->
            <div class="vp-box">
                <h2 class="vp-box-title"><span>🎨</span> <?php esc_html_e('Couleurs', 'volunpress'); ?></h2>
                
                <div class="vp-form-row vp-form-row-flex">
                    <div class="vp-form-col">
                        <label for="primary_color"><?php esc_html_e('Couleur principale', 'volunpress'); ?></label>
                        <input type="color" name="primary_color" id="primary_color" value="<?php echo esc_attr($options['primary_color'] ?? '#3498db'); ?>">
                    </div>
                    <div class="vp-form-col">
                        <label for="secondary_color"><?php esc_html_e('Couleur secondaire', 'volunpress'); ?></label>
                        <input type="color" name="secondary_color" id="secondary_color" value="<?php echo esc_attr($options['secondary_color'] ?? '#2ecc71'); ?>">
                    </div>
                </div>
                <small><?php esc_html_e('Ces couleurs sont utilisées dans les shortcodes', 'volunpress'); ?></small>
            </div>
        </div>
        
        <p class="submit">
            <button type="submit" name="volunpress_save_options" class="button button-primary button-large">
                <?php esc_html_e('Enregistrer les options', 'volunpress'); ?>
            </button>
        </p>
    </form>
    
    <!-- Aide shortcodes -->
    <div class="vp-box vp-box-help">
        <h2 class="vp-box-title"><span>📖</span> <?php esc_html_e('Aide - Shortcodes disponibles', 'volunpress'); ?></h2>
        
        <table class="vp-help-table">
            <tr>
                <td><code>[volunpress_leaderboard]</code></td>
                <td><?php esc_html_e('Affiche le classement des bénévoles', 'volunpress'); ?></td>
                <td><small>limit, show_level, show_badge, show_committee, committee_only</small></td>
            </tr>
            <tr>
                <td><code>[volunpress_volunteer id="X"]</code></td>
                <td><?php esc_html_e('Affiche la carte d\'un bénévole', 'volunpress'); ?></td>
                <td><small>id, email, show_progress, show_activities</small></td>
            </tr>
            <tr>
                <td><code>[volunpress_rewards]</code></td>
                <td><?php esc_html_e('Affiche les récompenses disponibles', 'volunpress'); ?></td>
                <td><small>columns</small></td>
            </tr>
            <tr>
                <td><code>[volunpress_stats]</code></td>
                <td><?php esc_html_e('Affiche les statistiques globales', 'volunpress'); ?></td>
                <td><small>show_volunteers, show_hours, show_points</small></td>
            </tr>
        </table>
    </div>
</div>
