<?php
if (!defined('ABSPATH')) {
    exit;
}

$stats = Volunpress_Volunteer::get_stats();
$monthly_stats = Volunpress_Activity::get_monthly_stats();
$recent_activities = Volunpress_Activity::get_recent(5);
$pending_claims = Volunpress_Reward::get_claims(array('status' => 'pending'));
$top_volunteers = Volunpress_Volunteer::get_all(array('is_active' => 1, 'limit' => 5));
$currency = Volunpress::get_option('currency_name', 'points');
?>

<div class="wrap volunpress-wrap">
    <div class="vp-header-banner">
        <div class="vp-header-content">
            <div class="vp-logo-section">
                <div class="vp-logo">
                    <span class="vp-logo-icon">🎯</span>
                    <div class="vp-logo-text">
                        <h1>Volunpress</h1>
                        <span class="vp-version">v<?php echo esc_html(VOLUNPRESS_VERSION); ?></span>
                    </div>
                </div>
                <p class="vp-tagline"><?php esc_html_e('Système gamifié de gestion des bénévoles', 'volunpress'); ?></p>
            </div>
            <div class="vp-header-stats">
                <div class="vp-header-stat">
                    <span class="vp-stat-num"><?php echo esc_html($stats['active_volunteers']); ?></span>
                    <span class="vp-stat-txt"><?php esc_html_e('Bénévoles', 'volunpress'); ?></span>
                </div>
                <div class="vp-header-stat">
                    <span class="vp-stat-num"><?php echo esc_html(number_format($stats['total_hours'], 0)); ?>h</span>
                    <span class="vp-stat-txt"><?php esc_html_e('Heures', 'volunpress'); ?></span>
                </div>
                <div class="vp-header-stat">
                    <span class="vp-stat-num"><?php echo esc_html(number_format($stats['total_points_earned'])); ?></span>
                    <span class="vp-stat-txt"><?php echo esc_html(ucfirst($currency)); ?></span>
                </div>
            </div>
        </div>
    </div>

    <!-- Section Guide d'utilisation -->
    <div class="vp-welcome-section">
        <div class="vp-welcome-grid">
            <div class="vp-welcome-card vp-card-primary">
                <div class="vp-card-icon">📖</div>
                <h3><?php esc_html_e('Bienvenue sur Volunpress !', 'volunpress'); ?></h3>
                <p><?php esc_html_e('Volunpress est un système de gamification pour gérer vos bénévoles. Motivez votre équipe avec un système de points et de récompenses attractif !', 'volunpress'); ?></p>
            </div>
            
            <div class="vp-welcome-card">
                <div class="vp-card-icon">👥</div>
                <h3><?php esc_html_e('Gestion des bénévoles', 'volunpress'); ?></h3>
                <p><?php esc_html_e('Ajoutez vos bénévoles, indiquez s\'ils sont membres du comité, suivez leurs cotisations et gérez leur statut (actif/inactif).', 'volunpress'); ?></p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-volunteers')); ?>" class="vp-btn"><?php esc_html_e('Gérer les bénévoles', 'volunpress'); ?> →</a>
            </div>
            
            <div class="vp-welcome-card">
                <div class="vp-card-icon">⏱️</div>
                <h3><?php esc_html_e('Heures & Points', 'volunpress'); ?></h3>
                <p><?php esc_html_e('Enregistrez les heures de bénévolat, les dons (convertis en points), les cotisations et les bonus spéciaux.', 'volunpress'); ?></p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-activities')); ?>" class="vp-btn"><?php esc_html_e('Ajouter des activités', 'volunpress'); ?> →</a>
            </div>
            
            <div class="vp-welcome-card">
                <div class="vp-card-icon">🎁</div>
                <h3><?php esc_html_e('Récompenses', 'volunpress'); ?></h3>
                <p><?php esc_html_e('Créez des récompenses que vos bénévoles peuvent obtenir avec leurs points : goodies, produits, privilèges...', 'volunpress'); ?></p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-rewards')); ?>" class="vp-btn"><?php esc_html_e('Créer des récompenses', 'volunpress'); ?> →</a>
            </div>
        </div>
    </div>

    <!-- Dashboard principal -->
    <div class="vp-dashboard-grid">
        <!-- Colonne gauche -->
        <div class="vp-dashboard-main">
            <!-- Stats du mois -->
            <div class="vp-box">
                <h2 class="vp-box-title">
                    <span>📊</span> <?php esc_html_e('Ce mois-ci', 'volunpress'); ?>
                </h2>
                <div class="vp-month-stats">
                    <div class="vp-month-stat">
                        <span class="vp-month-value"><?php echo esc_html($monthly_stats['total_activities']); ?></span>
                        <span class="vp-month-label"><?php esc_html_e('Activités', 'volunpress'); ?></span>
                    </div>
                    <div class="vp-month-stat">
                        <span class="vp-month-value"><?php echo esc_html(number_format($monthly_stats['total_hours'], 1)); ?>h</span>
                        <span class="vp-month-label"><?php esc_html_e('Heures', 'volunpress'); ?></span>
                    </div>
                    <div class="vp-month-stat">
                        <span class="vp-month-value"><?php echo esc_html(number_format($monthly_stats['total_points'])); ?></span>
                        <span class="vp-month-label"><?php echo esc_html(ucfirst($currency)); ?></span>
                    </div>
                </div>
            </div>

            <!-- Top bénévoles -->
            <div class="vp-box">
                <h2 class="vp-box-title">
                    <span>🏆</span> <?php esc_html_e('Top Bénévoles', 'volunpress'); ?>
                </h2>
                <?php if ($top_volunteers): ?>
                <div class="vp-top-list">
                    <?php $rank = 1; foreach ($top_volunteers as $vol): ?>
                    <div class="vp-top-item">
                        <span class="vp-top-rank"><?php echo $rank <= 3 ? array('🥇', '🥈', '🥉')[$rank-1] : '#'.$rank; ?></span>
                        <span class="vp-top-name">
                            <?php echo Volunpress_Volunteer::get_display_name($vol); ?>
                            <?php if ($vol->is_committee_member): ?><span class="vp-badge-small">Comité</span><?php endif; ?>
                        </span>
                        <span class="vp-top-points"><?php echo esc_html(number_format($vol->total_points)); ?> <?php echo esc_html($currency); ?></span>
                    </div>
                    <?php $rank++; endforeach; ?>
                </div>
                <?php else: ?>
                <p class="vp-empty"><?php esc_html_e('Aucun bénévole pour le moment.', 'volunpress'); ?></p>
                <?php endif; ?>
            </div>

            <!-- Activités récentes -->
            <div class="vp-box">
                <h2 class="vp-box-title">
                    <span>📝</span> <?php esc_html_e('Activités récentes', 'volunpress'); ?>
                </h2>
                <?php if ($recent_activities): ?>
                <div class="vp-activity-list">
                    <?php foreach ($recent_activities as $act): ?>
                    <div class="vp-activity-item">
                        <div class="vp-activity-info">
                            <strong><?php echo esc_html($act->first_name . ' ' . $act->last_name); ?></strong>
                            <span><?php echo esc_html($act->description); ?></span>
                        </div>
                        <div class="vp-activity-meta">
                            <span class="vp-activity-points">+<?php echo esc_html($act->points); ?></span>
                            <span class="vp-activity-date"><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($act->activity_date))); ?></span>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php else: ?>
                <p class="vp-empty"><?php esc_html_e('Aucune activité récente.', 'volunpress'); ?></p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Colonne droite -->
        <div class="vp-dashboard-side">
            <!-- Réclamations en attente -->
            <?php if ($pending_claims): ?>
            <div class="vp-box vp-box-warning">
                <h2 class="vp-box-title">
                    <span>⚠️</span> <?php printf(esc_html__('%d réclamation(s) en attente', 'volunpress'), count($pending_claims)); ?>
                </h2>
                <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-claims')); ?>" class="vp-btn vp-btn-full"><?php esc_html_e('Voir les réclamations', 'volunpress'); ?></a>
            </div>
            <?php endif; ?>

            <!-- Guide des shortcodes -->
            <div class="vp-box vp-box-info">
                <h2 class="vp-box-title">
                    <span>🔧</span> <?php esc_html_e('Shortcodes', 'volunpress'); ?>
                </h2>
                <div class="vp-shortcode-list">
                    <div class="vp-shortcode-item">
                        <code>[volunpress_leaderboard]</code>
                        <p><?php esc_html_e('Affiche le classement des bénévoles', 'volunpress'); ?></p>
                        <small>limit="10" show_level="yes" show_committee="no"</small>
                    </div>
                    <div class="vp-shortcode-item">
                        <code>[volunpress_volunteer id="5"]</code>
                        <p><?php esc_html_e('Affiche la carte d\'un bénévole', 'volunpress'); ?></p>
                        <small>id="X" ou email="..." show_progress="yes"</small>
                    </div>
                    <div class="vp-shortcode-item">
                        <code>[volunpress_rewards]</code>
                        <p><?php esc_html_e('Affiche les récompenses disponibles', 'volunpress'); ?></p>
                        <small>columns="3"</small>
                    </div>
                    <div class="vp-shortcode-item">
                        <code>[volunpress_stats]</code>
                        <p><?php esc_html_e('Affiche les statistiques globales', 'volunpress'); ?></p>
                        <small>show_volunteers="yes" show_hours="yes"</small>
                    </div>
                </div>
            </div>

            <!-- Actions rapides -->
            <div class="vp-box">
                <h2 class="vp-box-title">
                    <span>⚡</span> <?php esc_html_e('Actions rapides', 'volunpress'); ?>
                </h2>
                <div class="vp-quick-actions">
                    <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-volunteers&action=new')); ?>" class="vp-quick-btn">
                        <span>👤</span> <?php esc_html_e('Nouveau bénévole', 'volunpress'); ?>
                    </a>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-activities&action=new')); ?>" class="vp-quick-btn">
                        <span>➕</span> <?php esc_html_e('Ajouter des heures', 'volunpress'); ?>
                    </a>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-rewards&action=new')); ?>" class="vp-quick-btn">
                        <span>🎁</span> <?php esc_html_e('Créer récompense', 'volunpress'); ?>
                    </a>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-options')); ?>" class="vp-quick-btn">
                        <span>⚙️</span> <?php esc_html_e('Options', 'volunpress'); ?>
                    </a>
                </div>
            </div>

            <!-- Crédits -->
            <div class="vp-box vp-box-credits">
                <div class="vp-credits-content">
                    <p><strong>Volunpress</strong> v<?php echo esc_html(VOLUNPRESS_VERSION); ?></p>
                    <p><?php esc_html_e('Développé par', 'volunpress'); ?> <a href="mailto:info@dukiwi.com">Dukiwi SA</a></p>
                    <p><a href="https://www.volunpress.com" target="_blank">www.volunpress.com</a></p>
                </div>
            </div>
        </div>
    </div>
</div>
