<?php
if (!defined('ABSPATH')) {
    exit;
}

$message = isset($_GET['message']) ? sanitize_text_field($_GET['message']) : '';
$filter_status = isset($_GET['status']) ? sanitize_text_field($_GET['status']) : '';
$currency = Volunpress::get_option('currency_name', 'points');

$args = array();
if ($filter_status) $args['status'] = $filter_status;
$claims = Volunpress_Reward::get_claims($args);

$statuses = array(
    'pending' => array('label' => __('En attente', 'volunpress'), 'color' => '#f39c12'),
    'approved' => array('label' => __('Approuvé', 'volunpress'), 'color' => '#27ae60'),
    'rejected' => array('label' => __('Refusé', 'volunpress'), 'color' => '#e74c3c'),
    'delivered' => array('label' => __('Livré', 'volunpress'), 'color' => '#3498db'),
);
?>

<div class="wrap volunpress-wrap">
    <h1><?php esc_html_e('Réclamations de récompenses', 'volunpress'); ?></h1>
    
    <?php if ($message): ?>
    <div class="notice notice-success is-dismissible"><p><?php echo esc_html($message); ?></p></div>
    <?php endif; ?>
    
    <div class="vp-filters">
        <form method="get">
            <input type="hidden" name="page" value="volunpress-claims">
            <select name="status">
                <option value=""><?php esc_html_e('Tous les statuts', 'volunpress'); ?></option>
                <?php foreach ($statuses as $key => $status): ?>
                <option value="<?php echo esc_attr($key); ?>" <?php selected($filter_status, $key); ?>><?php echo esc_html($status['label']); ?></option>
                <?php endforeach; ?>
            </select>
            <button type="submit" class="button"><?php esc_html_e('Filtrer', 'volunpress'); ?></button>
        </form>
    </div>
    
    <?php if ($claims): ?>
    <table class="wp-list-table widefat fixed striped vp-table">
        <thead>
            <tr>
                <th><?php esc_html_e('Date', 'volunpress'); ?></th>
                <th><?php esc_html_e('Bénévole', 'volunpress'); ?></th>
                <th><?php esc_html_e('Récompense', 'volunpress'); ?></th>
                <th class="vp-col-center"><?php echo esc_html(ucfirst($currency)); ?></th>
                <th class="vp-col-center"><?php esc_html_e('Statut', 'volunpress'); ?></th>
                <th><?php esc_html_e('Actions', 'volunpress'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($claims as $claim): ?>
            <tr>
                <td><?php echo esc_html(date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($claim->claimed_at))); ?></td>
                <td><strong><?php echo esc_html($claim->first_name . ' ' . $claim->last_name); ?></strong></td>
                <td><?php echo esc_html($claim->reward_name); ?></td>
                <td class="vp-col-center"><?php echo esc_html(number_format($claim->points_spent)); ?></td>
                <td class="vp-col-center">
                    <span class="vp-status-badge" style="background-color: <?php echo esc_attr($statuses[$claim->status]['color']); ?>">
                        <?php echo esc_html($statuses[$claim->status]['label']); ?>
                    </span>
                </td>
                <td>
                    <?php if ($claim->status === 'pending'): ?>
                    <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=volunpress-claims&action=approve_claim&id=' . $claim->id), 'claim_action_' . $claim->id)); ?>" class="button button-small vp-btn-success"><?php esc_html_e('Approuver', 'volunpress'); ?></a>
                    <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=volunpress-claims&action=reject_claim&id=' . $claim->id), 'claim_action_' . $claim->id)); ?>" class="button button-small vp-btn-danger"><?php esc_html_e('Refuser', 'volunpress'); ?></a>
                    <?php elseif ($claim->status === 'approved'): ?>
                    <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=volunpress-claims&action=deliver_claim&id=' . $claim->id), 'claim_action_' . $claim->id)); ?>" class="button button-small"><?php esc_html_e('Marquer livré', 'volunpress'); ?></a>
                    <?php else: ?>
                    <span class="vp-processed">
                        <?php 
                        if ($claim->processed_at) {
                            printf(esc_html__('Traité le %s', 'volunpress'), date_i18n(get_option('date_format'), strtotime($claim->processed_at)));
                        }
                        ?>
                    </span>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php else: ?>
    <div class="vp-empty-state">
        <span class="vp-empty-icon">📋</span>
        <p><?php esc_html_e('Aucune réclamation pour le moment.', 'volunpress'); ?></p>
    </div>
    <?php endif; ?>
</div>
