<?php
if (!defined('ABSPATH')) {
    exit;
}

$action = isset($_GET['action']) ? sanitize_text_field($_GET['action']) : 'list';
$message = isset($_GET['message']) ? sanitize_text_field($_GET['message']) : '';
$preselect_volunteer = isset($_GET['volunteer_id']) ? (int) $_GET['volunteer_id'] : 0;
$currency = Volunpress::get_option('currency_name', 'points');
$points_per_hour = (int) Volunpress::get_option('points_per_hour', 10);
$donation_ratio = (float) Volunpress::get_option('donation_points_ratio', 1);

$volunteers = Volunpress_Volunteer::get_all(array('is_active' => 1, 'orderby' => 'first_name', 'order' => 'ASC'));
$activity_types = Volunpress_Activity::get_activity_types();
?>

<div class="wrap volunpress-wrap">
    <h1 class="wp-heading-inline">
        <?php echo $action === 'new' ? esc_html__('Nouvelle activité', 'volunpress') : esc_html__('Activités', 'volunpress'); ?>
    </h1>
    
    <?php if ($action === 'list'): ?>
    <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-activities&action=new')); ?>" class="page-title-action"><?php esc_html_e('Ajouter', 'volunpress'); ?></a>
    <?php else: ?>
    <a href="<?php echo esc_url(admin_url('admin.php?page=volunpress-activities')); ?>" class="page-title-action"><?php esc_html_e('← Retour à la liste', 'volunpress'); ?></a>
    <?php endif; ?>
    
    <?php if ($message): ?>
    <div class="notice notice-success is-dismissible"><p><?php echo esc_html($message); ?></p></div>
    <?php endif; ?>
    
    <?php if ($action === 'new'): ?>
    <!-- Formulaire d'ajout -->
    <form method="post" class="vp-form">
        <?php wp_nonce_field('volunpress_activity'); ?>
        
        <div class="vp-form-grid">
            <div class="vp-form-main">
                <div class="vp-box">
                    <h2 class="vp-box-title"><?php esc_html_e('Détails de l\'activité', 'volunpress'); ?></h2>
                    
                    <div class="vp-form-row">
                        <label for="volunteer_id"><?php esc_html_e('Bénévole', 'volunpress'); ?> *</label>
                        <select name="volunteer_id" id="volunteer_id" required>
                            <option value=""><?php esc_html_e('-- Sélectionner --', 'volunpress'); ?></option>
                            <?php foreach ($volunteers as $vol): ?>
                            <option value="<?php echo esc_attr($vol->id); ?>" <?php selected($preselect_volunteer, $vol->id); ?>>
                                <?php echo esc_html($vol->first_name . ' ' . $vol->last_name); ?>
                                (<?php echo esc_html(number_format($vol->total_points)); ?> <?php echo esc_html($currency); ?>)
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="vp-form-row">
                        <label for="activity_type"><?php esc_html_e('Type d\'activité', 'volunpress'); ?> *</label>
                        <select name="activity_type" id="activity_type" required>
                            <?php foreach ($activity_types as $key => $label): ?>
                            <option value="<?php echo esc_attr($key); ?>"><?php echo esc_html($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="vp-form-row">
                        <label for="description"><?php esc_html_e('Description', 'volunpress'); ?> *</label>
                        <input type="text" name="description" id="description" required placeholder="<?php esc_attr_e('Ex: Organisation de l\'événement annuel', 'volunpress'); ?>">
                    </div>
                    
                    <div class="vp-form-row vp-form-row-flex">
                        <div class="vp-form-col" id="hours-field">
                            <label for="hours"><?php esc_html_e('Heures', 'volunpress'); ?></label>
                            <input type="number" name="hours" id="hours" step="0.5" min="0" value="0">
                            <small><?php printf(esc_html__('1 heure = %d %s', 'volunpress'), $points_per_hour, $currency); ?></small>
                        </div>
                        <div class="vp-form-col" id="points-field" style="display: none;">
                            <label for="points"><?php echo esc_html(ucfirst($currency)); ?></label>
                            <input type="number" name="points" id="points" min="0" value="0">
                            <small id="donation-hint" style="display: none;"><?php printf(esc_html__('1 CHF = %s %s', 'volunpress'), $donation_ratio, $currency); ?></small>
                        </div>
                        <div class="vp-form-col">
                            <label for="activity_date"><?php esc_html_e('Date', 'volunpress'); ?> *</label>
                            <input type="date" name="activity_date" id="activity_date" required value="<?php echo esc_attr(date('Y-m-d')); ?>">
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="vp-form-side">
                <div class="vp-box vp-box-info">
                    <h3><?php esc_html_e('Types d\'activités', 'volunpress'); ?></h3>
                    <ul class="vp-type-list">
                        <li><strong><?php esc_html_e('Heures', 'volunpress'); ?></strong> - <?php printf(esc_html__('%d points/heure', 'volunpress'), $points_per_hour); ?></li>
                        <li><strong><?php esc_html_e('Don', 'volunpress'); ?></strong> - <?php esc_html_e('Convertir un don en points', 'volunpress'); ?></li>
                        <li><strong><?php esc_html_e('Cotisation', 'volunpress'); ?></strong> - <?php printf(esc_html__('%d points', 'volunpress'), Volunpress::get_option('points_membership', 20)); ?></li>
                        <li><strong><?php esc_html_e('Bonus', 'volunpress'); ?></strong> - <?php esc_html_e('Points manuels', 'volunpress'); ?></li>
                        <li><strong><?php esc_html_e('Événement', 'volunpress'); ?></strong> - <?php esc_html_e('Participation spéciale', 'volunpress'); ?></li>
                    </ul>
                </div>
                
                <button type="submit" name="volunpress_save_activity" class="button button-primary button-large vp-btn-full">
                    <?php esc_html_e('Ajouter l\'activité', 'volunpress'); ?>
                </button>
            </div>
        </div>
    </form>
    
    <script>
    jQuery(function($) {
        $('#activity_type').on('change', function() {
            var type = $(this).val();
            if (type === 'hours') {
                $('#hours-field').show();
                $('#points-field').hide();
            } else {
                $('#hours-field').hide();
                $('#points-field').show();
                $('#donation-hint').toggle(type === 'donation');
            }
        });
    });
    </script>
    
    <?php else: ?>
    <!-- Liste des activités -->
    <?php 
    $filter_type = isset($_GET['filter_type']) ? sanitize_text_field($_GET['filter_type']) : '';
    $filter_volunteer = isset($_GET['filter_volunteer']) ? (int) $_GET['filter_volunteer'] : 0;
    
    $args = array('limit' => 50);
    if ($filter_type) $args['activity_type'] = $filter_type;
    if ($filter_volunteer) $args['volunteer_id'] = $filter_volunteer;
    
    $activities = Volunpress_Activity::get_all($args);
    ?>
    
    <div class="vp-filters">
        <form method="get">
            <input type="hidden" name="page" value="volunpress-activities">
            <select name="filter_type">
                <option value=""><?php esc_html_e('Tous les types', 'volunpress'); ?></option>
                <?php foreach ($activity_types as $key => $label): ?>
                <option value="<?php echo esc_attr($key); ?>" <?php selected($filter_type, $key); ?>><?php echo esc_html($label); ?></option>
                <?php endforeach; ?>
            </select>
            <select name="filter_volunteer">
                <option value=""><?php esc_html_e('Tous les bénévoles', 'volunpress'); ?></option>
                <?php foreach ($volunteers as $vol): ?>
                <option value="<?php echo esc_attr($vol->id); ?>" <?php selected($filter_volunteer, $vol->id); ?>><?php echo esc_html($vol->first_name . ' ' . $vol->last_name); ?></option>
                <?php endforeach; ?>
            </select>
            <button type="submit" class="button"><?php esc_html_e('Filtrer', 'volunpress'); ?></button>
        </form>
    </div>
    
    <table class="wp-list-table widefat fixed striped vp-table">
        <thead>
            <tr>
                <th><?php esc_html_e('Date', 'volunpress'); ?></th>
                <th><?php esc_html_e('Bénévole', 'volunpress'); ?></th>
                <th><?php esc_html_e('Type', 'volunpress'); ?></th>
                <th><?php esc_html_e('Description', 'volunpress'); ?></th>
                <th class="vp-col-center"><?php esc_html_e('Heures', 'volunpress'); ?></th>
                <th class="vp-col-center"><?php echo esc_html(ucfirst($currency)); ?></th>
                <th><?php esc_html_e('Actions', 'volunpress'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if ($activities): foreach ($activities as $act): ?>
            <tr>
                <td><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($act->activity_date))); ?></td>
                <td><strong><?php echo esc_html($act->first_name . ' ' . $act->last_name); ?></strong></td>
                <td>
                    <span class="vp-badge vp-badge-type-<?php echo esc_attr($act->activity_type); ?>">
                        <?php echo esc_html($activity_types[$act->activity_type] ?? $act->activity_type); ?>
                    </span>
                </td>
                <td><?php echo esc_html($act->description); ?></td>
                <td class="vp-col-center"><?php echo $act->hours > 0 ? esc_html(number_format($act->hours, 1)) . 'h' : '-'; ?></td>
                <td class="vp-col-center"><strong class="vp-points-positive">+<?php echo esc_html($act->points); ?></strong></td>
                <td>
                    <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=volunpress-activities&action=delete_activity&id=' . $act->id), 'delete_activity_' . $act->id)); ?>" class="button button-small vp-btn-danger" onclick="return confirm('<?php esc_attr_e('Supprimer cette activité ? Les points seront recalculés.', 'volunpress'); ?>');"><?php esc_html_e('Supprimer', 'volunpress'); ?></a>
                </td>
            </tr>
            <?php endforeach; else: ?>
            <tr><td colspan="7" class="vp-empty-row"><?php esc_html_e('Aucune activité trouvée.', 'volunpress'); ?></td></tr>
            <?php endif; ?>
        </tbody>
    </table>
    <?php endif; ?>
</div>
